/************************************************************/
/* PROJECT NAME: API	                                    */
/* Project:      LPC2100 Training course                    */
/* Engineer:     T Martin       tmartin@hitex.co.uk         */
/* Filename:     API.c                                     */
/* Language:     C                      	                */
/* Compiler:     Keil ARM	V2.00b		                    */
/* Assembler:    				                            */
/*                                                          */
/************************************************************/
/* COPYRIGHT: Hitex UK Ltd 		2005						*/
/* LICENSE:   THIS VERSION CREATED FOR FREE DISTRIBUTION	*/
/************************************************************/
/* Function:                                                */
/*                                                          */
/* IAP Example  						          			*/
/*															*/
/* Demonstrates use of the In Application Functions			*/
/*															*/	
/* Oscillator frequency 12.000 Mhz							*/
/* Target board Keil MCB2100								*/
/************************************************************/

typedef void (*IAP)(unsigned int [],unsigned int []);
IAP iap_bypointer;
void iap_byfunction (unsigned *cmd,unsigned *rslt,unsigned entry);

unsigned command[5];
unsigned result[5];
char Ram_Arry[] = "Hello World";
char *Ram_Pointer;


void main (void) __arm				   		//Compile this in ARM instruction set
{
unsigned char index;

iap_bypointer = (IAP) 0x7FFFFFF1;			//set IAP entry address in function pointer

Ram_Pointer = 0x40000100;					//Set pointer to RAM 
for (index = 0; index<0x0B; index++)		//Copy data to be written to flash into the RAM
{
*Ram_Pointer = Ram_Arry[index];
Ram_Pointer++;
}

command[0] = ; 				   			//command code for "Read part ID"
iap_byfunction();	//Call IAP functions by function method


command[0] = 50;							//Prepare sector five for a write operayion
command[1] = 5;
command[2] = 5;
iap_bypointer(command,result);

command[0] = 52;						   //erase sector five
command[1] = 5;
command[2] = 5;
command[3] = 12000;						   //Cclk == 12Mhz Pll is disabled in startup code
iap_bypointer(command,result);

command[0] = 50;							//Prepare sector five for a write operayion
command[1] = 5;
command[2] = 5;
iap_bypointer(command,result);

command[0] = 51;						   //write 512 bytes from address 0x40000100
command[1] = 0x0000A000;				   //to 0x0000A000 in flash memory;
command[2] = 0x40000100;
command[3] = 512;
command[4] = 12000;						   // see erase comment above
iap_byfunction(command,result,0x7FFFFFF0);

while(1)
{
;
}

}

void iap_byfunction (unsigned *cmd,unsigned *rslt,unsigned entry) __thumb		//compile this in Thumb instruction set
{
__asm { }											//move entry address into PC



}			
